﻿using UnityEditor;
using UnityEngine;
using System.IO ;
/// <summary>
/// Create asset bundles for different OS
/// </summary>
public class AssetBundleCreation
{
    private static string s_exportPath = "Assets/AssetBundles" ;

#if UNITY_IOS
    [MenuItem("ARF/Build AssetBundles iOS")]
    static void BuildAllAssetBundlesIOS()
    {
        CheckDirectory();
        UnityEditor.XR.ARSubsystems.ARBuildProcessor.PreprocessBuild( BuildTarget.iOS);
        BuildPipeline.BuildAssetBundles( s_exportPath, BuildAssetBundleOptions.ForceRebuildAssetBundle, BuildTarget.iOS);
      //  BuildPipeline.BuildAssetBundles(s_exportPath, BuildAssetBundleOptions.None, BuildTarget.iOS);
    }
#endif
    
    static void CheckDirectory()
    {
        if (!Directory.Exists(s_exportPath))
        {
            Directory.CreateDirectory(s_exportPath);
        }
    }
}