﻿using UnityEditor;
using UnityEngine;
using System.IO ;
/// <summary>
/// Create asset bundles for different OS
/// </summary>
public class AssetBundleCreation
{
    private static string s_exportPath = "Assets/AssetBundles" ;

#if UNITY_IOS
    [MenuItem("ARF/Build AssetBundles iOS")]
    static void BuildAllAssetBundlesIOS()
    {
        CheckDirectory();
        BuildPipeline.BuildAssetBundles(s_exportPath, BuildAssetBundleOptions.None, BuildTarget.iOS);
    }
#endif

#if UNITY_EDITOR_WIN
    [MenuItem("ARF/Build AssetBundles Windows")]
    static void BuildAllAssetBundlesWindows()
    {
        CheckDirectory();
        BuildPipeline.BuildAssetBundles(s_exportPath, BuildAssetBundleOptions.None, BuildTarget.StandaloneWindows);
    }
#endif


#if UNITY_ANDROID
    [MenuItem("ARF/Build AssetBundles Android")]
    static void BuildAllAssetBundlesAndroid()
    {
        CheckDirectory();
        BuildPipeline.BuildAssetBundles(s_exportPath, BuildAssetBundleOptions.None, BuildTarget.Android);
    }
#endif
    
    static void CheckDirectory()
    {
        if (!Directory.Exists(s_exportPath))
        {
            Directory.CreateDirectory(s_exportPath);
        }
    }
}