using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;

public class NavigationSimulation : MonoBehaviour
{
    public GameObject[] checkpoints;
    private int currentCheckpointIndex = 0;
    [SerializeField] TMP_Text checkpointText;

    [Space(8)]
    [SerializeField]
    private bool deactivateAfterStart = true;

    // Start is called before the first frame update
    void Start()
    {
        if (deactivateAfterStart)
            foreach (GameObject child in checkpoints)
            {
                child.SetActive(false);
            }
    }

    // Update is called once per frame
    void Update()
    {

    }

    private void ActivateCheckpoint(int contentId)
    {
        checkpoints[contentId - 1].SetActive(true);
    }

    private void DeactivateCheckpoint(int contentId)
    {
        checkpoints[contentId - 1].SetActive(false);
    }

    private void OnTriggerEnter(Collider collision)
    {
        Debug.Log("Collision detected at: " + collision.gameObject.name + " Object: " + checkpoints[currentCheckpointIndex].name);

        // Check if the collided object is the current checkpoint
        string n = checkpoints[currentCheckpointIndex].name;

        int id_content = int.Parse(checkpoints[currentCheckpointIndex].name.Split(' ')[1]);
        int id = int.Parse(collision.gameObject.name.Split(' ')[2]);

        if (id == id_content)
        {
            // Deactivate the current checkpoint
            if (currentCheckpointIndex > 0) DeactivateCheckpoint(currentCheckpointIndex);

            // Check if there are more checkpoints
            if (currentCheckpointIndex < checkpoints.Length)
            {
                currentCheckpointIndex++;

                // Activate the next checkpoint
                checkpointText.text = "Checkpoint " + currentCheckpointIndex;
                
                ActivateCheckpoint(currentCheckpointIndex);
            }
            else
            {
                // All checkpoints reached, do something
                Debug.Log("All checkpoints reached!");
            }
        }
    }
}
