using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace ETSI.ARF.OpenAPI.WorldAnalysis
{
    /// <summary>
    /// Simple class to debug the requests
    /// </summary>
    public class BaseClient
    {
        static public bool EnableClientLog = true;
        public string lastJsonText;
        public long lastPayload;

        protected void _prepareRequest(ETSI.ARF.OpenAPI.WorldAnalysis.IHttpClient client, System.Net.Http.HttpRequestMessage request, string url)
        {
            if (EnableClientLog)
            {
                Debug.Log("[REST][URL] Send request: " + client.BaseAddress + url);
                Debug.Log("[REST][URL] Send request: " + request);
            }
        }

        protected void _processResponse(ETSI.ARF.OpenAPI.WorldAnalysis.IHttpClient client, System.Net.Http.HttpResponseMessage response)
        {
            lastJsonText = response.Content.ReadAsStringAsync().Result.ToString();
            lastPayload = response.Content.Headers.ContentLength.Value;

            var status_ = (int)response.StatusCode;

            if (EnableClientLog)
            {
                Debug.Log("[REST][Data] Status: " + status_ + " Response: " + client.BaseAddress + " Len: " + lastPayload + " JSON: " + lastJsonText);
            }
        }
    }
}