//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: March 2024
//

using System;
using System.Threading.Tasks;
using System.Collections.Generic;
using UnityEngine;

using ETSI.ARF.OpenAPI;
using ETSI.ARF.OpenAPI.WorldAnalysis;

namespace ETSI.ARF.WorldAnalysis.REST
{
    public class RequestBase<T> // where T : Trackable, WorldAnchor, WorldLink
    {
        static protected WorldAnalysisServer wsServer;
        static protected WorldAnalysisClient apiClient;

        static protected string token = "ARF_Permission";

        // Cache the current list
        static public Dictionary<Guid, object> listOfObjects = new Dictionary<Guid, object>();


        //
        // Helpers
        //
        static protected void OnReceiveObject<TObj>(Task<TObj> t, object id)
        {
            if (t.IsCompleted)
            {
                ResponseObject<TObj> o = (ResponseObject<TObj>)id;
                o.responseTime = DateTime.Now;
                o.result = t.Result;
                Debug.Log($"[REST] Server Response = {o.result.ToString()} (ID={o.transactionId}, Msg={o.message})");

                o.callback?.Invoke(o);
            }
            else Debug.Log("[REST] OpenAPI Timeout!");
        }

        static protected void OnReceiveListOfObjects<TObj>(Task<List<TObj>> t, object id) where TObj : IModel
        {
            if (t.IsCompleted)
            {
                ResponseObject<List<TObj>> o = (ResponseObject<List<TObj>>)id;
                o.responseTime = DateTime.Now;
                o.result = t.Result;
                Debug.Log($"[REST] Server Response = Got {o.result.Count} entrie(s) (ID={o.transactionId}, Msg={o.message})");

                listOfObjects.Clear();
                foreach (var i in o.result)
                {
                    listOfObjects.Add(i.Uuid, i);
                }
                o.callback?.Invoke(o);
            }
            else Debug.Log("[REST] OpenAPI Timeout!");
        }

    }
}
