//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: August 2024
//

using UnityEngine;

namespace ETSI.ARF.WorldAnalysis
{
    [System.Serializable]
    [CreateAssetMenu(fileName = "ARFWorldAnalysisUser", menuName = "ARF World Analysis/Create User", order = 1)]
    public class WorldAnalysisUser : ScriptableObject
    {
        [SerializeField] public string userName = "myName";
        [SerializeField] public string company = "";
        [SerializeField] public string UUID = System.Guid.Empty.ToString();
    }
}