using System;
using UnityEngine;
using ETSI.ARF.OpenAPI.WorldAnalysis;
using ETSI.ARF.WorldAnalysis;
using static WorldAnalysisInterface;
using ETSI.ARF.WorldAnalysis.REST;

//Implementation of the WorldAnalysis interface
public class WorldAnalysisREST : MonoBehaviour, WorldAnalysisInterface
{
    static protected string token = "ARF_Permission";

    public WorldAnalysisServer waServer;

    // For sync calls
    private WorldAnalysisClient apiClient;

    // For async calls
    private WorldAnalysisClient apiClientAsync;


    #region Unity_Methods

    /// <summary>
    /// Unity Awake Method
    /// </summary>
    protected void Awake()
    {
        // sync
        var httpClient = new BasicHTTPClient(waServer.URI);
        apiClient = new WorldAnalysisClient(httpClient);

        // async
        //var httpClientAsync = new UnityWebRequestHttpClient(waServer.URI);
        //apiClientAsync = new WorldAnalysisClient(httpClientAsync);
    }

    /// <summary>
    /// Unity Start Method
    /// </summary>
    protected void Start()
    {
    }

    /// <summary>
    /// Unity Update Method
    /// </summary>
    protected void Update()
    {
    }

    #endregion

    #region Test methods
    public void CheckServer()
    {
        string ping = AdminRequest.PingSync(waServer);
        string state = AdminRequest.AdminSync(waServer);
        string ver = AdminRequest.VersionSync(waServer);
        Debug.Log("[REST] WA Ping: " + ping);
        Debug.Log("[REST] WA State: " + state);
        Debug.Log("[REST] WA Version: " + ver);
    }

    public string GetWebSocketEndpoint()
    {
        string res = "empty";

        SubscriptionSingleRequest param = new SubscriptionSingleRequest();
        param.Mode = Mode_WorldAnalysis.DEVICE_TO_TRACKABLES;
        param.Target = Guid.Parse("fa8bbe40-8052-11ec-a8a3-0242ac120002"); // test

        SubscriptionSingle response = apiClient.SubscribeToPose(token, "1", param);
        res = response.WebsocketUrl;
        return res;
    } 
    
    public void PrintCapabilities()
    {
        string res = "Capabilities:";

        Response2 cap = apiClient.GetCapabilities(token, "1");
        foreach (var item in cap.Capabilities)
        {
            res += "\n" + item.TrackableType;
        }
        Debug.Log("[REST] Capabilities: " + res);
    }
    #endregion

    #region ARF_API
    //
    // Implementation of the endpoints
    //
    public AskFrameRateResult SetPoseEstimationFramerate(string token, PoseConfigurationTrackableType type, EncodingInformationStructure encodingInformation, int minimumFramerate)
    {
        return AskFrameRateResult.NOT_SUPPORTED; ///We cannot set any framerate for tracking on ARKit and ARCore
    }

    public PoseEstimationResult GetLastPose(string token, Guid uuid, Mode_WorldAnalysis mode, out ETSI.ARF.OpenAPI.WorldAnalysis.Pose pose)
    {
        pose = null;
        return PoseEstimationResult.OK;
    }


    public PoseEstimationResult[] GetLastPoses(string token, Guid[] uuids, Mode_WorldAnalysis[] modes, out ETSI.ARF.OpenAPI.WorldAnalysis.Pose[] poses)
    {
        poses = null;
        return null;
    }

    public InformationSubscriptionResult SubscribeToPose(string token, Guid uuid, Mode_WorldAnalysis mode, PoseCallback callback, ref int validity, out Guid subscriptionUUID)
    {
        subscriptionUUID = Guid.Empty;
        return InformationSubscriptionResult.OK;
    }

    public InformationSubscriptionResult[] SubscribeToPoses(string token, Guid[] uuids, Mode_WorldAnalysis[] modes, PoseCallback callback, ref int validity, out Guid[] subscriptionUUIDs)
    {
        subscriptionUUIDs = null;
        return null;
    }

    public InformationSubscriptionResult GetSubsription(string token, Guid subscriptionUUID, out PoseCallback callback, out Guid target, out Mode_WorldAnalysis mode, out int validity)
    {
        callback = null;
        target = Guid.Empty;
        mode = Mode_WorldAnalysis.TRACKABLES_TO_DEVICE;
        validity = 0;
        return InformationSubscriptionResult.OK;
    }

    public InformationSubscriptionResult UpdateSubscription(string token, Guid subscriptionUUID, Mode_WorldAnalysis mode, int validity, PoseCallback callback)
    {
        return InformationSubscriptionResult.OK;
    }

    public InformationSubscriptionResult UnSubscribeToPose(Guid subscriptionUUID)
    {
        return InformationSubscriptionResult.OK;
    }

    public CapabilityResult GetCapabilities(string token, out Capability[] capabilities)
    {
        capabilities = null;
        return CapabilityResult.OK;
    }

    public CapabilityResult GetCapability(string token, Guid uuid, out bool isSupported, out TypeWorldStorage type, out Capability[] capability)
    {
        isSupported = false;
        type = TypeWorldStorage.UNKNOWN;
        capability = null;
        return CapabilityResult.OK;
    }

    #endregion
}