//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: March 2024
//

using System;
using System.Threading.Tasks;
using UnityEngine;

using ETSI.ARF.OpenAPI;
using ETSI.ARF.OpenAPI.WorldAnalysis;

namespace ETSI.ARF.WorldAnalysis.REST
{
    public class AdminRequest : RequestBase<string>
    {
        //
        // Wrapper for the endpoints
        //
        static public string PingSync(WorldAnalysisServer ws)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldAnalysisClient(httpClient);

            string response = apiClient.GetPing();
            return response;
        }

        static public ResponseObject<string> PingAsync(WorldAnalysisServer ws, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldAnalysisClient(httpClient);

            Debug.Log("[REST] Request Ping...");
            ResponseObject<string> ro = new ResponseObject<string>("Request Ping", func);
            apiClient.GetPingAsync(ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }

        static public string AdminSync(WorldAnalysisServer ws)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldAnalysisClient(httpClient);

            string response = apiClient.GetAdmin();
            return response;
        }

        static public ResponseObject<string> AdminAsync(WorldAnalysisServer ws, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldAnalysisClient(httpClient);

            Debug.Log("[REST] Request Admin...");
            ResponseObject<string> ro = new ResponseObject<string>("Request Admin", func);
            apiClient.GetAdminAsync(ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }

        static public string VersionSync(WorldAnalysisServer ws)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldAnalysisClient(httpClient);

            string response = apiClient.GetVersion();
            return response;
        }

        static public ResponseObject<string> VersionAsync(WorldAnalysisServer ws, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldAnalysisClient(httpClient);

            Debug.Log("[REST] Request Version...");
            ResponseObject<string> ro = new ResponseObject<string>("Request Version", func);
            apiClient.GetVersionAsync(ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }
    }
}
