using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace ETSI.ARF.OpenAPI.WorldAnalysis
{
    public interface IModel
    {
        public System.Guid Uuid { get; set; }  // Bug: SylR: Why is Uuid not capitalized (UUID)???

        public string ToJson();
    }

    // Class to monitor the server
    public class Server : IModel
    {
        public System.Guid Uuid { get; set; }
        public string Name { get; set; }

        public Server(string name)
        {
            Uuid = Guid.Empty;
            Name = name;
        }

        public string ToJson() { return JsonUtility.ToJson(this); }
    }

    //
    // Implement here some constructors
    //
    public partial class Pose : IModel
    {
        public Pose()
        {
            Uuid = Guid.NewGuid();
        }

        public string ToJson() { return JsonUtility.ToJson(this); }
    }
}