using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.Threading.Tasks; 
using System.Net ;
using System.IO ;

public class WorldAnalysisARFoundationHelper 
{
    /// <summary>
    /// Downaload file http
    /// </summary>
    /// <param name="toLoad">load url</param>
    /// <returns>key and value with local path and file name with extension</returns>
    public static async Task<KeyValuePair<string, string> > DownloadFileHTTP(string toLoad)
    {
        string filePath = "";
        string fileName = "";
        #if UNITY_EDITOR
            string folder = Application.streamingAssetsPath;
#else
            string folder = Application.persistentDataPath;
#endif

        string uniqueFileName = "/Temp"+ System.Guid.NewGuid()+".data";
        using (var client = new WebClient())
        {
            await client.DownloadFileTaskAsync(toLoad, folder + uniqueFileName);
            string header_contentDisposition = client.ResponseHeaders["content-disposition"];
            if (header_contentDisposition == null)
            {
                string[] splittedLink = toLoad.Split('/');
                fileName = splittedLink[splittedLink.Length - 1];
            }
            else
            {
                fileName = new System.Net.Mime.ContentDisposition(header_contentDisposition).FileName;
            }
            filePath = folder + "/" + fileName;
            if (File.Exists(filePath))
            {
                File.Delete(filePath);
            }
            File.Move(folder + uniqueFileName, filePath);
        }
        return new KeyValuePair<string, string>(filePath , fileName);
    }
}
