*This repository is part of the outcomes of the Specialist Task Force 669 focusing on the World Analysis as part of the ETSI ISG Augmented Reality Framework architecture (https://www.etsi.org/deliver/etsi_gs/ARF/001_099/003/01.01.01_60/gs_ARF003v010101p.pdf).*
*The set of the World Anlysis components includes:*

*•	The C++ and C# source code for servers and clients  generated from OpenAPI available here (https://forge.etsi.org/rep/arf/openapi)*

*•	Multiple Unity plugin (wrappers) implementing the World Analysis with various AR technologies

*All these components are available under the ETSI Labs group “World Analysis API Helpers”:  https://labs.etsi.org/rep/arf/world-analysis-api-helpers*

*This repository and the associated components depend on the World Storage components developed in the context of the Specialist Task Force 620 that focused on the authoring of a World Representation and which are vailable under the ETSI Labs group “World Storage API Helpers”: https://labs.etsi.org/rep/arf/world-storage-api-helpers*

*If you wish to contribute to this project or any other projects in the context of the [ETSI ISG Augmented Reality Framework architecture](https://www.etsi.org/committee/1420-arf), please refer to the ["How to get involved in an ISG" section on the ETSI website](https://www.etsi.org/how-to-get-involved-in-an-isg)*

---


# ARFoundation World Analysis #

This wrapper for the World Analysis relies on the ARFoundation (version 5.1.x) Unity package available here: https://docs.unity3d.com/Packages/com.unity.xr.arfoundation@5.1/manual/index.html and is compatible with ARKit and ARCore.

## Supported Trackables and Setup

### Image Trackables ###

Image markers are supported on both iOS and Android platforms through ARKit and ARCore.

The name of the Trackable in the World Storage must correspond to the name of a file (jpg or png) placed in the Unity persistent data path of the application on the user device. The variable keyvalueTags of the Trackable can also contain a parameter with the "url" key providing a link to download the image.

More information about ARFoundation Image Tracking can be found here: https://docs.unity3d.com/Packages/com.unity.xr.arfoundation@5.1/manual/index.html

### Mesh Trackables ###

Mesh trackables are supported on iOS through ARKit.

ARKit can track meshes that are defined in the .arobject format. Such an object can be scanned with the sample application provided here: https://developer.apple.com/documentation/arkit/arkit_in_ios/content_anchors/scanning_and_detecting_3d_objects

Unity serializes .arobject into ARKitReferenceObjectEntry in the editor. ARKitReferenceObjectEntry cannot then be imported at runtime from a .arobjject file. Dynamic loading is not supported yet.

To support adding .arobject without recompiling the full application, we use a dedicated AssetBundle.
* Place you .arobject in the Assets Folder. For instance under Assets/ARObjects
* Associate the ARKitReferenceObjectEntry with the arfmeshes AssetBundle in the editor
* Build the AssetBundles. For that you can use the following menu: ARF--> Build AssetBundles iOS

Then you have two options:
* Placing the AssetBundle "arfmeshes" file (with this exact file name) in the Unity persistent data path of the application on the user device.
* The variable keyvalueTags of the Trackable can also contain a parameter with the "url" key providing a link to download the AssetBundle to the Unity persistent data path on the user device. Only one AssetBundle can be loaded.

The name of the Trackable in the World Storage must correspond to the name of the ARKitReferenceObjectEntry.

More information about ARFoundation Mesh Tracking can be found here: https://docs.unity3d.com/Packages/com.unity.xr.arfoundation@5.1/manual/features/object-tracking.html



