*This repository is part of the outcomes of the Specialist Task Force 669 focusing on the World Analysis as part of the ETSI ISG Augmented Reality Framework architecture (https://www.etsi.org/deliver/etsi_gs/ARF/001_099/003/01.01.01_60/gs_ARF003v010101p.pdf).*
*The set of the World Anlysis components includes:*

*•	The C++ and C# source code for servers and clients  generated from OpenAPI available here (https://forge.etsi.org/rep/arf/openapi)*

*•	Multiple Unity plugin (wrappers) implementing the World Analysis with various AR technologies

*All these components are available under the ETSI Labs group “World Analysis API Helpers”:  https://labs.etsi.org/rep/arf/world-analysis-api-helpers*

*This repository and the associated components depend on the World Storage components developed in the context of the Specialist Task Force 620 that focused on the authoring of a World Representation and which are vailable under the ETSI Labs group “World Storage API Helpers”: https://labs.etsi.org/rep/arf/world-storage-api-helpers*

*If you wish to contribute to this project or any other projects in the context of the [ETSI ISG Augmented Reality Framework architecture](https://www.etsi.org/committee/1420-arf), please refer to the ["How to get involved in an ISG" section on the ETSI website](https://www.etsi.org/how-to-get-involved-in-an-isg)*

---


# ARFoundation World Analysis #

This wrapper for the World Analysis relies on the ARFoundation (version 5.1.x) Unity package available here: https://docs.unity3d.com/Packages/com.unity.xr.arfoundation@5.1/manual/index.html and is compatible with ARKit and ARCore.
Some capabilities are also compatible with VisionOS based on Polyspatial 1.X https://docs.unity3d.com/Packages/com.unity.polyspatial.visionos@1.3/manual/index.html


## Supported Trackables and Setup

### Image Trackables ###

Image markers are supported on both iOS and Android platforms through ARKit and ARCore. (Use Trackable Type "OTHER" with version 1.01)

The name of the Trackable in the World Storage must correspond to the name of a file (jpg or png) placed in the Unity persistent data path of the application on the user device. The variable keyvalueTags of the Trackable can also contain a parameter with the "url" key providing a link to download the image.

More information about ARFoundation Image Tracking can be found here: https://docs.unity3d.com/Packages/com.unity.xr.arfoundation@5.1/manual/index.html

Image Trackables are also supported on VisionOS but cannot be loaded dynamcally at runtime due to limitations of Polyspatial 1.X. Dynamic creation of runtime image library is supported with Polyspatial 2.X but this feature has not been tested yet with this package. 
To track an image you need to create a static reference Image Library named VisionOSImageLibrary in a Resources folder. The name of the image in this library must correspond to the name of the corresponding Trackable. Other parameters included in the World Storage such as size and unit are ignored.

### Mesh Trackables ###

Mesh trackables are only supported on iOS through ARKit.

ARKit can track meshes that are defined in the .arobject format. Such an object can be scanned with the sample application provided here: https://developer.apple.com/documentation/arkit/arkit_in_ios/content_anchors/scanning_and_detecting_3d_objects

Unity serializes .arobject into ARKitReferenceObjectEntry in the editor. ARKitReferenceObjectEntry cannot then be imported at runtime from a .arobjject file. Dynamic loading is not supported yet.

To support adding .arobject without recompiling the full application, we use a dedicated AssetBundle.
* Place you .arobject in the Assets Folder. For instance under Assets/ARObjects
* Associate the ARKitReferenceObjectEntry with the arfmeshes AssetBundle in the editor
* Build the AssetBundles. For that you can use the following menu: ARF--> Build AssetBundles iOS

Then you have two options:
* Placing the AssetBundle "arfmeshes" file (with this exact file name) in the Unity persistent data path of the application on the user device.
* The variable keyvalueTags of the Trackable can also contain a parameter with the "url" key providing a link to download the AssetBundle to the Unity persistent data path on the user device. Only one AssetBundle can be loaded.

The name of the Trackable in the World Storage must correspond to the name of the ARKitReferenceObjectEntry.

More information about ARFoundation Mesh Tracking can be found here: https://docs.unity3d.com/Packages/com.unity.xr.arfoundation@5.1/manual/features/object-tracking.html

### Map Trackables ###

#### iOS: ARWorldMap ####

On iOS/ARKit Map Trackables are supported with  ARWorlMap feature. Only one Map Trackable per World Graph is supported. ARWorlMap is not supported on VisionOS.

In ARKit, an ARWorldMap includes ARKit's awareness of the physical space in which the user moves the device that can be serialized into a file to be reloaded later on the same or on another device: 
https://developer.apple.com/documentation/arkit/arworldmap

The .map file can be placed in the Unity persistent data path of the application on the user device with the following name: "ARkitWorlMap.map". Alternatively, the variable keyvalueTags of the Trackable can also contain a parameter with the "url" key providing a link to download the map file.

The map needs to include at least one Anchor. You can use one of them as the origin of the map by setting the name of the Trackable in the World Storage with the TrackableId of the ARAnchor stored in the map. https://docs.unity3d.com/Packages/com.unity.xr.arfoundation@5.1/api/UnityEngine.XR.ARSubsystems.TrackableId.html

Samples for creating and serializing an ARWorldMap with ARFoundation can be found here:
https://github.com/Unity-Technologies/arfoundation-samples/blob/main/Assets/Scripts/Runtime/ARWorldMapController.cs 

#### Android ARCore Cloud Anchors ####

On Android/ARCore Map Trackables are supported with Google Cloud Anchors.

Cloud Anchors are anchors that are hosted on the ARCore API cloud endpoint. This hosting enables users to share experiences in the same app: see https://developers.google.com/ar/develop/cloud-anchors

For using ARCore cloud anchors you need to:
* Add the the arcore unity extensions package as a dependency of the Unity project  https://github.com/google-ar/arcore-unity-extensions
* Add to the runtime asmdef of this package a reference to Google.XR.ARCoreExtensions.asmdef
* Add a new Script Define Symbol in the Unity project settings: "ETSIARF_ARCORE_EXTENSIONS"
* Then, follow the instructions detailed here https://developers.google.com/ar/develop/unity-arf/cloud-anchors/developer-guide and here  https://developers.google.com/ar/develop/authorization?platform=unity-arf to configure the project and your google cloud account

To use a Map Trackable that corresponds to a Google Cloud Anchor, the name of the Trackable in the World Storage must correspond to the name of Google UUID of the anchor.


### Geo Trackables ###

#### iOS: perspectives ####

On iOS, Geo Trackables are not yet supported with this package.

A first possibility for adding this support is to adapt the Google GeoSpatial code and then run your iOS application with the ARCore AR backend.

A second possibility is to add the support for ARKit GeoTracking: https://developer.apple.com/documentation/arkit/arkit_in_ios/content_anchors/tracking_geographic_locations_in_ar
This feature is not implemented yet due to the small number of places supported (see https://developer.apple.com/documentation/arkit/argeotrackingconfiguration)

#### Android: Google GeoSpatial ####

On Android/ARCore Geo Trackables are supported with Google Geospatial Anchors.

Geospatial Anchors are anchors that are hosted on the ARCore API cloud endpoint. This hosting enables users to share experiences in the same app using GPS and Google Earth data: see https://developers.google.com/ar/develop/geospatial

For using ARCore Geospatial Anchors you need to:
* Add the the arcore unity extensions package as a dependency of the Unity project  https://github.com/google-ar/arcore-unity-extensions
* Add to the runtime asmdef of this package a reference to Google.XR.ARCoreExtensions.asmdef
* Add a new Script Define Symbol in the Unity project settings: "ETSIARF_ARCORE_EXTENSIONS"
* Then, follow the instructions detailed here https://developers.google.com/ar/develop/unity-arf/geospatial/enable-android and here  https://developers.google.com/ar/develop/authorization?platform=unity-arf to configure the project and your google cloud account

To use a Geo Pose Trackable that corresponds to a Google Geospatial Anchor, the payload of the Trackable in the World Storage must be an array of doubles following this format : [latitude, longitude, altitude, rotationX, rotationY, rotationZ] in base 64.
