using UnityEngine;

public interface WorldAnalysisARFoundationModule
{
    /// <summary>
    /// Informations about a trackable
    /// </summary>
    public class TrackableInfo
    {
        public string                                               name;
        public int                                                  timeStamp;
        public ETSI.ARF.OpenAPI.WorldAnalysis.PoseEstimationState   state;
        public double                                               confidence;
        public Vector3                                              position;
        public Quaternion                                           rotation;
        public ETSI.ARF.OpenAPI.WorldAnalysis.TrackableType         trackableType;
    }

    /// <summary>
    /// Initialize tracking module
    /// </summary>
    public void Initialize();

    /// <summary>
    /// Add to the list of trackable that the module need to tracked
    /// </summary>
    /// <param name="trackable">Trackable with its parameters</param>
    /// <returns>supported or not</returns>
    public bool AddTrackable(ETSI.ARF.OpenAPI.WorldStorage.Trackable trackable);

    /// <summary>
    ///  
    /// </summary>
    /// <param name="name"></param>
    public TrackableInfo GetPoseTrackable(string name);

}