using UnityEngine;
using System;

public interface WorldAnalysisARFoundationModule
{
    /// <summary>
    /// Informations about a trackable
    /// </summary>
    public class TrackableInfo
    {
        public string                                               name;
        public int                                                  timeStamp;
        public ETSI.ARF.OpenAPI.WorldAnalysis.PoseEstimationState   state;
        public double                                               confidence;
        public Vector3                                              position;
        public Quaternion                                           rotation;
        public ETSI.ARF.OpenAPI.WorldAnalysis.TrackableType         trackableType;
    }

    /// <summary>
    /// Initialize tracking module
    /// </summary>
    public void Initialize();

    /// <summary>
    /// Add to the list of trackable that the module need to tracked
    /// </summary>
    /// <param name="trackable">Trackable with its parameters</param>
    /// <returns>supported or not</returns>
    public bool AddTrackable(ETSI.ARF.OpenAPI.WorldStorage.Trackable trackable);

    /// <summary>
    /// Get the pose of the trackable from its uuid
    /// </summary>
    /// <param name="uuid">id of the trackable</param>
    /// <returns>null or trackableInfo with last updated values</returns>
    public TrackableInfo GetPoseTrackable(Guid uuid);
    
    /// <summary>
    ///  Initialize capability object with the features of the module
    /// </summary>
    public ETSI.ARF.OpenAPI.WorldAnalysis.Capability  GetSupportedCapability();

}